/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class OracleOfTheAlphaEffect
extends OneShotEffect {
    private static final List<String> power9 = Arrays.asList("Ancestral Recall", "Black Lotus", "Mox Emerald", "Mox Jet", "Mox Pearl", "Mox Ruby", "Timetwister", "Time Walk");

    OracleOfTheAlphaEffect() {
        super(Outcome.Benefit);
        this.staticText = "conjure the Power Nine into your library, then shuffle";
    }

    private OracleOfTheAlphaEffect(OracleOfTheAlphaEffect effect) {
        super((OneShotEffect)effect);
    }

    public OracleOfTheAlphaEffect copy() {
        return new OracleOfTheAlphaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet cards = new HashSet();
        for (String cardName : power9) {
            CardRepository.instance.findCards(new CardCriteria().setCodes(new String[]{"LEA"}).name(cardName)).stream().findFirst().map(CardInfo::createCard).ifPresent(cards::add);
        }
        game.loadCards(cards, source.getControllerId());
        player.moveCards(cards, Zone.LIBRARY, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

