/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class OrbsOfWardingEffect
extends PreventionEffectImpl {
    OrbsOfWardingEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a creature would deal damage to you, prevent 1 of that damage";
    }

    private OrbsOfWardingEffect(OrbsOfWardingEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getTargetId().equals(source.getControllerId()) && (permanent = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && permanent.isCreature(game)) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public OrbsOfWardingEffect copy() {
        return new OrbsOfWardingEffect(this);
    }
}

