/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class OrcusPrinceOfUndeathBoostEffect
extends OneShotEffect {
    OrcusPrinceOfUndeathBoostEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Each other creature gets -X/-X until end of turn. You lose X life";
    }

    private OrcusPrinceOfUndeathBoostEffect(OrcusPrinceOfUndeathBoostEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrcusPrinceOfUndeathBoostEffect copy() {
        return new OrcusPrinceOfUndeathBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        game.addEffect((ContinuousEffect)new BoostAllEffect(-xValue, -xValue, Duration.EndOfTurn, true), source);
        controller.loseLife(xValue, game, source, false);
        return true;
    }
}

