/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandCard;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class OreskosExplorerEffect
extends OneShotEffect {
    OreskosExplorerEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "search your library for up to X Plains cards, where X is the number of players who control more lands than you. Reveal those cards, put them into your hand, then shuffle";
    }

    private OreskosExplorerEffect(OreskosExplorerEffect effect) {
        super((OneShotEffect)effect);
    }

    public OreskosExplorerEffect copy() {
        return new OreskosExplorerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        int controllerLands = game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), controller.getId(), game);
        int landsToSearch = 0;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            if (playerId.equals(controller.getId()) || controllerLands >= game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), playerId, game)) continue;
            ++landsToSearch;
        }
        if (landsToSearch > 0) {
            FilterLandCard filterPlains = new FilterLandCard("up to " + landsToSearch + " Plains cards");
            filterPlains.add((Predicate)SubType.PLAINS.getPredicate());
            TargetCardInLibrary target = new TargetCardInLibrary(0, landsToSearch, (FilterCard)filterPlains);
            if (controller.searchLibrary(target, source, game, controller.getId())) {
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                controller.moveCards(cards.getCards(game), Zone.HAND, source, game);
            }
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

