/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrimsPrayerTriggeredAbility
extends TriggeredAbilityImpl {
    public OrimsPrayerTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private OrimsPrayerTriggeredAbility(OrimsPrayerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OrimsPrayerTriggeredAbility copy() {
        return new OrimsPrayerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        boolean applied = false;
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null) {
            return false;
        }
        int numberAttackingController = 0;
        for (UUID attackersId : game.getCombat().getAttackers()) {
            Permanent attackingCreature = game.getPermanent(attackersId);
            if (attackingCreature == null || game.getCombat().getDefenderId(attackersId) != this.getControllerId()) continue;
            ++numberAttackingController;
            applied = true;
        }
        if (applied && numberAttackingController > 0) {
            this.getEffects().clear();
            this.getEffects().add((Object)new GainLifeEffect(numberAttackingController));
        }
        return applied;
    }

    public String getRule() {
        return "Whenever one or more creatures attack you, you gain 1 life for each attacking creature.";
    }
}

