/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackYouAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class OrzhovAdvokistEffect
extends OneShotEffect {
    OrzhovAdvokistEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may put two +1/+1 counters on a creature they control. If a player does, creatures that player controls can't attack you or planeswalkers you control until your next turn";
    }

    private OrzhovAdvokistEffect(OrzhovAdvokistEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrzhovAdvokistEffect copy() {
        return new OrzhovAdvokistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList players = new ArrayList();
        ArrayList creatures = new ArrayList();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(this.outcome, "Put two +1/+1 counters on a creature you control?", source, game)) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 1);
            target.withNotTarget(true);
            target.withChooseHint("to add counters to");
            player.choose(this.outcome, (Target)target, source, game);
            Optional.ofNullable(target).map(Target::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> {
                creatures.add(permanent.getId());
                players.add(player.getId());
            });
        }
        for (UUID creatureId : creatures) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null) continue;
            creature.addCounters(CounterType.P1P1.createInstance(2), creature.getControllerId(), source, game);
        }
        for (UUID playerId : players) {
            if (source.isControlledBy(playerId)) continue;
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(playerId));
            game.addEffect((ContinuousEffect)new CantAttackYouAllEffect(Duration.UntilYourNextTurn, filter, true), source);
        }
        return true;
    }
}

