/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrzhovCharmReturnToHandEffect
extends OneShotEffect {
    OrzhovCharmReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target creature you control and all Auras you control attached to it to their owner's hand";
    }

    private OrzhovCharmReturnToHandEffect(OrzhovCharmReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrzhovCharmReturnToHandEffect copy() {
        return new OrzhovCharmReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Card)permanent);
        permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> p.isControlledBy(source.getControllerId())).filter(p -> p.hasSubtype(SubType.AURA, game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.HAND, source, game);
    }
}

