/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class OskarRubbishReclaimerCastEffect
extends OneShotEffect {
    OskarRubbishReclaimerCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast it from your graveyard.";
    }

    private OskarRubbishReclaimerCastEffect(OskarRubbishReclaimerCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = (Card)this.getValue("discardedCard");
        if (controller == null || card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        if (!controller.chooseUse(Outcome.Benefit, "Cast " + card.getName() + "?", source, game)) {
            return false;
        }
        CardUtil.castSingle((Player)controller, (Ability)source, (Game)game, (Card)card);
        return true;
    }

    public OskarRubbishReclaimerCastEffect copy() {
        return new OskarRubbishReclaimerCastEffect(this);
    }
}

