/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.o.OublietteDelayedTriggeredAbility;
import mage.cards.o.OubliettePhasePreventEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OubliettePhaseOutEffect
extends OneShotEffect {
    OubliettePhaseOutEffect() {
        super(Outcome.Detriment);
        this.staticText = "target creature phases out until {this} leaves the battlefield. Tap that creature as it phases in this way.";
    }

    private OubliettePhaseOutEffect(OubliettePhaseOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public OubliettePhaseOutEffect copy() {
        return new OubliettePhaseOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (sourcePermanent == null || permanent == null) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference((MageObject)permanent, game);
        permanent.phaseOut(game);
        game.addEffect((ContinuousEffect)new OubliettePhasePreventEffect(mor), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OublietteDelayedTriggeredAbility(mor), source);
        return true;
    }
}

