/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutAllEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.o.OutOfTimeDelayedTriggeredAbility;
import mage.cards.o.OutOfTimeReplacementEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OutOfTimePhaseOutEffect
extends OneShotEffect {
    OutOfTimePhaseOutEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "untap all creatures, then those creatures phase out until {this} leaves the battlefield. Put a time counter on {this} for each creature that phased out this way";
    }

    private OutOfTimePhaseOutEffect(OutOfTimePhaseOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public OutOfTimePhaseOutEffect copy() {
        return new OutOfTimePhaseOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
        int numCreatures = creatures.size();
        if (numCreatures > 0) {
            HashSet<UUID> creatureIds = new HashSet<UUID>(numCreatures);
            for (Permanent creature : creatures) {
                creature.untap(game);
                creatureIds.add(creature.getId());
            }
            Permanent outOfTime = game.getPermanent(source.getSourceId());
            if (outOfTime != null) {
                new PhaseOutAllEffect(new ArrayList(creatureIds)).apply(game, source);
                game.processAction();
                new AddCountersSourceEffect(CounterType.TIME.createInstance(numCreatures)).apply(game, source);
                game.getState().setValue("phasedOutCreatures" + source.getId().toString(), creatureIds);
                game.getState().setValue("phasedOutBySourceId" + source.getSourceId(), (Object)source.getId());
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new OutOfTimeDelayedTriggeredAbility(), source);
                game.addEffect((ContinuousEffect)new OutOfTimeReplacementEffect(), source);
            }
        }
        return true;
    }
}

