/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class OutbreakEffect
extends OneShotEffect {
    OutbreakEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Choose a creature type. All creatures of that type get -1/-1 until end of turn";
    }

    private OutbreakEffect(OutbreakEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (player != null && player.choose(this.outcome, (Choice)typeChoice, game)) {
            game.informPlayers(player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            FilterCreaturePermanent filter = new FilterCreaturePermanent("All creatures of the chosen type");
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            BoostAllEffect effect = new BoostAllEffect(-1, -1, Duration.WhileOnBattlefield, filter, false);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public OutbreakEffect copy() {
        return new OutbreakEffect(this);
    }
}

