/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class OverclockedElectromancerWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> map = new HashMap<MageObjectReference, Integer>();

    OverclockedElectromancerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        int excess = ((DamagedPermanentEvent)event).getExcess();
        if (excess > 0) {
            this.map.compute(new MageObjectReference(event.getTargetId(), game), (mor, i) -> i == null ? excess : Integer.sum(i, excess));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    public static int getAmount(Permanent permanent, Game game) {
        return permanent != null ? ((OverclockedElectromancerWatcher)game.getState().getWatcher(OverclockedElectromancerWatcher.class)).map.getOrDefault(new MageObjectReference((MageObject)permanent, game), 0) : 0;
    }
}

