/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class OvermasterWatcher
extends Watcher {
    protected boolean ready = false;
    protected UUID uncounterableSpell;

    OvermasterWatcher() {
        super(WatcherScope.PLAYER);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && this.ready && this.uncounterableSpell == null && event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && (spell.isSorcery(game) || spell.isInstant(game))) {
            this.uncounterableSpell = spell.getId();
            this.ready = false;
        }
    }

    public boolean isUncounterable(UUID spellId) {
        return spellId.equals(this.uncounterableSpell);
    }

    public void setReady() {
        this.ready = true;
    }
}

