/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class OverwhelmingIntellectEffect
extends OneShotEffect {
    OverwhelmingIntellectEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target creature spell. Draw cards equal to that spell's mana value";
    }

    private OverwhelmingIntellectEffect(OverwhelmingIntellectEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverwhelmingIntellectEffect copy() {
        return new OverwhelmingIntellectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (controller != null && spell != null) {
            game.getStack().counter(source.getFirstTarget(), source, game);
            controller.drawCards(spell.getManaValue(), source, game);
            return true;
        }
        return false;
    }
}

