/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.OviyaPashiriSageLifecrafterToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class OviyaPashiriSageLifecrafterEffect
extends OneShotEffect {
    OviyaPashiriSageLifecrafterEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X colorless Construct artifact creature token, where X is the number of creatures you control";
    }

    private OviyaPashiriSageLifecrafterEffect(OviyaPashiriSageLifecrafterEffect effect) {
        super((OneShotEffect)effect);
    }

    public OviyaPashiriSageLifecrafterEffect copy() {
        return new OviyaPashiriSageLifecrafterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int creatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
            return new CreateTokenEffect((Token)new OviyaPashiriSageLifecrafterToken(creatures)).apply(game, source);
        }
        return false;
    }
}

