/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class CounterSourceEffect
extends OneShotEffect {
    CounterSourceEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "any player may discard three cards. If a player does, counter {this}";
    }

    private CounterSourceEffect(CounterSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CounterSourceEffect copy() {
        return new CounterSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            DiscardTargetCost cost = new DiscardTargetCost(new TargetCardInHand(3, 3, new FilterCard()));
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                Player player = game.getPlayer(playerId);
                cost.clearPaid();
                if (player == null || !cost.canPay(source, source, player.getId(), game) || !player.chooseUse(this.outcome, "Discard three cards to counter " + sourceObject.getIdName() + '?', source, game) || !cost.pay(source, game, source, playerId, false, null)) continue;
                game.informPlayers(player.getLogName() + " discards 3 cards to counter " + sourceObject.getIdName() + '.');
                Spell spell = game.getStack().getSpell(source.getSourceId());
                if (spell == null) continue;
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

