/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class PackHuntEffect
extends OneShotEffect {
    PackHuntEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to three cards with the same name as target creature, reveal them, put them into your hand, then shuffle";
    }

    private PackHuntEffect(PackHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public PackHuntEffect copy() {
        return new PackHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        FilterPermanentCard filter = new FilterPermanentCard();
        filter.add((Predicate)new NamePredicate(permanent.getName()));
        return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 3, (FilterCard)filter), true).apply(game, source);
    }
}

