/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PactWeaponEffect
extends OneShotEffect {
    PactWeaponEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card and reveal it. The creature gets +X/+X until end of turn and you lose X life, where X is that card's mana value.";
    }

    private PactWeaponEffect(PactWeaponEffect effect) {
        super((OneShotEffect)effect);
    }

    public PactWeaponEffect copy() {
        return new PactWeaponEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null || game.getPermanent(permanent.getAttachedTo()) == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (controller.drawCards(1, source, game) != 1) {
            return true;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card == null || card.getManaValue() == 0) {
            return true;
        }
        game.addEffect(new BoostTargetEffect(card.getManaValue(), card.getManaValue()).setTargetPointer((TargetPointer)new FixedTarget(permanent.getAttachedTo(), game)), source);
        controller.loseLife(card.getManaValue(), game, source, false);
        return true;
    }
}

