/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;

class PainForAllSecondEffect
extends OneShotEffect {
    PainForAllSecondEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals that much damage to each opponent";
    }

    private PainForAllSecondEffect(PainForAllSecondEffect effect) {
        super((OneShotEffect)effect);
    }

    public PainForAllSecondEffect copy() {
        return new PainForAllSecondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID permanentId = this.getTargetPointer().getFirst(game, source);
        int damage = (Integer)this.getValue("damage");
        if (permanentId == null || damage < 1) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Optional.ofNullable(opponentId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.damage(damage, permanentId, source, game));
        }
        return true;
    }
}

