/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class PainfulQuandryEffect
extends OneShotEffect {
    PainfulQuandryEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that player loses 5 life unless they discard a card";
    }

    private PainfulQuandryEffect(PainfulQuandryEffect effect) {
        super((OneShotEffect)effect);
    }

    public PainfulQuandryEffect copy() {
        return new PainfulQuandryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            boolean paid = false;
            DiscardTargetCost cost = new DiscardTargetCost(new TargetCardInHand());
            if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.Detriment, "Discard a card (otherwise you lose 5 life)?", source, game)) {
                paid = cost.pay(source, game, source, player.getId(), false, null);
            }
            if (!paid) {
                player.loseLife(5, game, source, false);
            }
            return true;
        }
        return false;
    }
}

