/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.p.PairODiceLostTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class PairODiceLostEffect
extends OneShotEffect {
    PairODiceLostEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll two six-sided dice. Return any number of cards with total mana value X or less from your graveyard to your hand, where X is the total of those results";
    }

    private PairODiceLostEffect(PairODiceLostEffect effect) {
        super((OneShotEffect)effect);
    }

    public PairODiceLostEffect copy() {
        return new PairODiceLostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int rolls = player.rollDice(this.outcome, source, game, 6, 2, 0).stream().mapToInt(x -> x).sum();
        PairODiceLostTarget target = new PairODiceLostTarget(rolls);
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        return true;
    }
}

