/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class PairedTacticianTriggeredAbility
extends TriggeredAbilityImpl {
    PairedTacticianTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
    }

    private PairedTacticianTriggeredAbility(PairedTacticianTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PairedTacticianTriggeredAbility copy() {
        return new PairedTacticianTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.sourceId)) return false;
        if (!game.getCombat().getAttackers().stream().filter(uuid -> !this.getSourceId().equals(uuid)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).anyMatch(permanent -> permanent.hasSubtype(SubType.WARRIOR, game))) return false;
        return true;
    }

    public String getRule() {
        return "Whenever {this} and at least one other Warrior attack, put a +1/+1 counter on {this}.";
    }
}

