/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class PakoArcaneRetrieverWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> playerMap = new HashMap<UUID, Set<MageObjectReference>>();

    PakoArcaneRetrieverWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
    }

    void addCard(UUID playerId, Card card, Game game) {
        this.playerMap.computeIfAbsent(playerId, u -> new HashSet()).add(new MageObjectReference((MageObject)card, game));
    }

    boolean checkCard(UUID playerId, Card card, Game game) {
        if (card == null) {
            return false;
        }
        int zoneChangeDifference = game.getState().getZone(card.getId()) == Zone.STACK ? 1 : 0;
        return this.playerMap.computeIfAbsent(playerId, u -> new HashSet()).stream().anyMatch(ref -> ref.getSourceId().equals(card.getId()) && ref.getZoneChangeCounter() == game.getState().getZoneChangeCounter(card.getId()) - zoneChangeDifference);
    }
}

