/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PalaceJailerReturnExiledPermanentsEffect
extends OneShotEffect {
    PalaceJailerReturnExiledPermanentsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return exiled creature";
    }

    private PalaceJailerReturnExiledPermanentsEffect(PalaceJailerReturnExiledPermanentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PalaceJailerReturnExiledPermanentsEffect copy() {
        return new PalaceJailerReturnExiledPermanentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileZone;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null && (exileZone = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC())) != null) {
            ExileZone exile = game.getExile().getExileZone(exileZone);
            if (exile != null) {
                controller.moveCards(new LinkedHashSet(exile.getCards(game)), Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
            return true;
        }
        return false;
    }
}

