/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.card.ManaValueLessThanOrEqualToSourcePowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class PaladinElizabethTaggerdyEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("a creature card with mana value less than or equal to {this}'s power");

    public PaladinElizabethTaggerdyEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put a creature card with mana value X or less from your hand onto the battlefield tapped and attacking, where X is {this}'s power";
    }

    private PaladinElizabethTaggerdyEffect(PaladinElizabethTaggerdyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        TargetCardInHand target = new TargetCardInHand(filter);
        if (controller != null && target.canChoose(controller.getId(), source, game) && target.choose(this.outcome, controller.getId(), source.getSourceId(), source, game)) {
            if (!target.getTargets().isEmpty()) {
                Permanent permanent;
                UUID cardId = target.getFirstTarget();
                Card card = controller.getHand().get(cardId, game);
                if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                    game.getCombat().addAttackingCreature(permanent.getId(), game);
                }
            }
            return true;
        }
        return false;
    }

    public PaladinElizabethTaggerdyEffect copy() {
        return new PaladinElizabethTaggerdyEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ManaValueLessThanOrEqualToSourcePowerPredicate.instance);
    }
}

