/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Optional;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class PalantirOfOrthancEffect
extends OneShotEffect {
    PalantirOfOrthancEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then target opponent may have you draw a card. If that player doesn't, you mill X cards, where X is the number of influence counters on {this}, and that player loses life equal to the total mana value of those cards.";
    }

    private PalantirOfOrthancEffect(PalantirOfOrthancEffect effect) {
        super((OneShotEffect)effect);
    }

    public PalantirOfOrthancEffect copy() {
        return new PalantirOfOrthancEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        if (opponent.chooseUse(this.outcome, "Have " + controller.getName() + " draw a card?", source, game)) {
            return controller.drawCards(1, source, game) > 0;
        }
        int counters = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(permanent -> permanent.getCounters(game)).map(c -> c.getCount(CounterType.INFLUENCE)).orElse(0);
        if (counters < 1) {
            return false;
        }
        int total = controller.millCards(counters, source, game).getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
        opponent.loseLife(total, game, source, false);
        return true;
    }
}

