/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class PanopticMirrorCastEffect
extends OneShotEffect {
    PanopticMirrorCastEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "you may copy a card exiled with {this}. If you do, you may cast the copy without paying its mana cost";
    }

    private PanopticMirrorCastEffect(PanopticMirrorCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public PanopticMirrorCastEffect copy() {
        return new PanopticMirrorCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent PanopticMirror2 = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (PanopticMirror2 == null) {
            PanopticMirror2 = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (PanopticMirror2 != null && PanopticMirror2.getImprinted() != null && !PanopticMirror2.getImprinted().isEmpty() && controller != null) {
            Card cardToCopy;
            CardsImpl cards = new CardsImpl();
            for (UUID uuid : PanopticMirror2.getImprinted()) {
                Card card = game.getCard(uuid);
                if (card == null) continue;
                if (card instanceof SplitCard) {
                    cards.add((Card)((SplitCard)card).getLeftHalfCard());
                    cards.add((Card)((SplitCard)card).getRightHalfCard());
                    continue;
                }
                if (card instanceof ModalDoubleFacedCard) {
                    cards.add((Card)((ModalDoubleFacedCard)card).getLeftHalfCard());
                    cards.add((Card)((ModalDoubleFacedCard)card).getRightHalfCard());
                    continue;
                }
                cards.add(card);
            }
            if (cards.size() == 1) {
                cardToCopy = (Card)cards.getCards(game).iterator().next();
            } else {
                TargetCard target = new TargetCard(1, Zone.EXILED, new FilterCard("card to copy"));
                controller.choose(Outcome.Copy, (Cards)cards, target, source, game);
                cardToCopy = cards.get(target.getFirstTarget(), game);
            }
            if (cardToCopy != null) {
                Card copy = game.copyCard(cardToCopy, source, source.getControllerId());
                if (controller.chooseUse(Outcome.PlayForFree, "Cast the copied card without paying mana cost?", source, game)) {
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), (Object)Boolean.TRUE);
                    controller.cast(controller.chooseAbilityForCast(copy, game, true), game, true, new ApprovingObject(source, game));
                    game.getState().setValue("PlayFromNotOwnHandZone" + copy.getId(), null);
                }
            }
            return true;
        }
        return false;
    }
}

