/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;

class PanopticProjektorReplacementEffect
extends ReplacementEffectImpl {
    PanopticProjektorReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If turning a face-down permanent face up causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private PanopticProjektorReplacementEffect(PanopticProjektorReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PanopticProjektorReplacementEffect copy() {
        return new PanopticProjektorReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event instanceof NumberOfTriggersEvent) {
            GameEvent sourceEvent;
            NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
            if (source.isControlledBy(event.getPlayerId()) && (sourceEvent = numberOfTriggersEvent.getSourceEvent()) != null && sourceEvent.getType() == GameEvent.EventType.TURNED_FACE_UP) {
                return game.getPermanent(numberOfTriggersEvent.getSourceId()) != null;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

