/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ParallectricFeedbackEffect
extends OneShotEffect {
    ParallectricFeedbackEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to target spell's controller equal to that spell's mana value";
    }

    private ParallectricFeedbackEffect(ParallectricFeedbackEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParallectricFeedbackEffect copy() {
        return new ParallectricFeedbackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player spellController;
        Spell spell;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (spell = game.getStack().getSpell(source.getFirstTarget())) != null && (spellController = game.getPlayer(spell.getControllerId())) != null) {
            spellController.damage(spell.getManaValue(), source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

