/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class ParallelThoughtsReplacementEffect
extends ReplacementEffectImpl {
    ParallelThoughtsReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.DrawCard);
        this.staticText = "If you would draw a card, you may instead put the top card of the pile you exiled into your hand";
    }

    private ParallelThoughtsReplacementEffect(ParallelThoughtsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ParallelThoughtsReplacementEffect copy() {
        return new ParallelThoughtsReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Set cards;
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source));
        Set set = cards = exileZone != null ? exileZone.getCards(game) : null;
        if (controller != null && cards != null && !cards.isEmpty() && controller.chooseUse(this.outcome, "Draw a card from the pile you exiled instead drawing from your library?", source, game)) {
            Card card = (Card)cards.iterator().next();
            if (card != null) {
                controller.moveCards(card, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

