/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.UntapAttachedEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ParalyzeEffect
extends DoIfCostPaid {
    ParalyzeEffect() {
        super((Effect)new UntapAttachedEffect(), (Cost)new GenericManaCost(4));
    }

    private ParalyzeEffect(ParalyzeEffect effect) {
        super((DoIfCostPaid)effect);
    }

    public ParalyzeEffect copy() {
        return new ParalyzeEffect(this);
    }

    protected Player getPayingPlayer(Game game, Ability source) {
        Permanent attachedTo;
        Permanent attachment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (attachment != null && attachment.getAttachedTo() != null && (attachedTo = game.getPermanent(attachment.getAttachedTo())) != null) {
            return game.getPlayer(attachedTo.getControllerId());
        }
        return null;
    }

    public String getText(Mode mode) {
        return "that player may " + CardUtil.addCostVerb((String)this.cost.getText()) + ". If the player does, untap the creature.";
    }
}

