/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class PardicDragonEffect
extends OneShotEffect {
    PardicDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may put a time counter on this card";
    }

    private PardicDragonEffect(PardicDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public PardicDragonEffect copy() {
        return new PardicDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Card sourceCard = game.getCard(source.getSourceId());
        if (opponent != null && sourceCard != null) {
            if (opponent.chooseUse(this.outcome, "Put a time counter on " + sourceCard.getName() + '?', source, game)) {
                sourceCard.addCounters(CounterType.TIME.createInstance(), opponent.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

