/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class PardicMinerEffect
extends ContinuousRuleModifyingEffectImpl {
    PardicMinerEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "Target player can't play lands this turn.";
    }

    private PardicMinerEffect(PardicMinerEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public PardicMinerEffect copy() {
        return new PardicMinerEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't play lands this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getFirstTarget());
    }
}

