/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PermanentsEnteredBattlefieldWatcher;

class ParkHeightsPegasusEffect
extends OneShotEffect {
    ParkHeightsPegasusEffect() {
        super(Outcome.DrawCard);
        this.staticText = "draw a card if you had two or more creatures enter the battlefield under your control this turn";
    }

    private ParkHeightsPegasusEffect(ParkHeightsPegasusEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParkHeightsPegasusEffect copy() {
        return new ParkHeightsPegasusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents;
        PermanentsEnteredBattlefieldWatcher watcher = (PermanentsEnteredBattlefieldWatcher)game.getState().getWatcher(PermanentsEnteredBattlefieldWatcher.class);
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (watcher != null && controller != null && (permanents = watcher.getThisTurnEnteringPermanents(controllerId)) != null) {
            int creatures = 0;
            for (Permanent permanent : permanents) {
                if (!permanent.isCreature(game) || ++creatures < 2) continue;
                controller.drawCards(1, source, game);
                return true;
            }
        }
        return false;
    }
}

