/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ParkerLuckEffect
extends OneShotEffect {
    ParkerLuckEffect() {
        super(Outcome.Damage);
        this.staticText = "two target players each reveal the top card of their library. They each lose life equal to the mana value of the card revealed by the other player. Then they each put the card they revealed into their hand";
    }

    protected ParkerLuckEffect(ParkerLuckEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParkerLuckEffect copy() {
        return new ParkerLuckEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetOne = game.getPlayer((UUID)this.getTargetPointer().getTargets(game, source).get(0));
        Player targetTwo = game.getPlayer((UUID)this.getTargetPointer().getTargets(game, source).get(1));
        if (targetOne == null || targetTwo == null) {
            return false;
        }
        Card targetOneCard = targetOne.getLibrary().getFromTop(game);
        int targetOneMv = 0;
        Card targetTwoCard = targetTwo.getLibrary().getFromTop(game);
        int targetTwoMv = 0;
        if (targetOneCard != null) {
            targetOne.revealCards(source, (Cards)new CardsImpl(targetOneCard), game);
            targetOneMv = targetOneCard.getManaValue();
        }
        if (targetTwoCard != null) {
            targetTwo.revealCards(source, (Cards)new CardsImpl(targetTwoCard), game);
            targetTwoMv = targetTwoCard.getManaValue();
        }
        targetOne.loseLife(targetTwoMv, game, source, false);
        targetTwo.loseLife(targetOneMv, game, source, false);
        targetOne.moveCards(targetOneCard, Zone.HAND, source, game);
        targetTwo.moveCards(targetTwoCard, Zone.HAND, source, game);
        return true;
    }
}

