/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PathwayArrowsEffect
extends OneShotEffect {
    PathwayArrowsEffect() {
        super(Outcome.Benefit);
        this.staticText = "This creature deals 1 damage to target creature. If a colorless creature is dealt damage this way, tap it";
    }

    private PathwayArrowsEffect(PathwayArrowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PathwayArrowsEffect copy() {
        return new PathwayArrowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int damageDealt;
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null && (damageDealt = targetCreature.damage(1, source.getSourceId(), source, game, false, true)) > 0 && targetCreature.getColor(game).isColorless()) {
                targetCreature.tap(source, game);
            }
            return true;
        }
        return false;
    }
}

