/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PatronOfTheOrochiEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public PatronOfTheOrochiEffect() {
        super(Outcome.Untap);
        this.staticText = "Untap all Forests and all green creatures";
    }

    private PatronOfTheOrochiEffect(PatronOfTheOrochiEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }

    public PatronOfTheOrochiEffect copy() {
        return new PatronOfTheOrochiEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.FOREST.getPredicate(), (Predicate)Predicates.and((Predicate)CardType.CREATURE.getPredicate(), (Predicate)new ColorPredicate(ObjectColor.GREEN))));
    }
}

