/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PeerIntoTheAbyssEffect
extends OneShotEffect {
    PeerIntoTheAbyssEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player draws cards equal to half the number of cards in their library and loses half their life. Round up each time.";
    }

    private PeerIntoTheAbyssEffect(PeerIntoTheAbyssEffect effect) {
        super((OneShotEffect)effect);
    }

    public PeerIntoTheAbyssEffect copy() {
        return new PeerIntoTheAbyssEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        targetPlayer.drawCards((int)Math.ceil((double)targetPlayer.getLibrary().size() / 2.0), source, game);
        targetPlayer.loseLife((int)Math.ceil((double)targetPlayer.getLife() / 2.0), game, source, false);
        return true;
    }
}

