/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PerceptionBobbleheadEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.BOBBLEHEAD);
    private static final FilterCard filter2 = new FilterCard();
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    PerceptionBobbleheadEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top X cards of your library, where X is the number of Bobbleheads you control. You may cast a spell with mana value 3 or less from among them without paying its mana cost. Put the rest on the bottom of your library in a random order";
    }

    private PerceptionBobbleheadEffect(PerceptionBobbleheadEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerceptionBobbleheadEffect copy() {
        return new PerceptionBobbleheadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int count = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (player == null || count < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, count));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter2);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter2.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
        hint = new ValueHint("Bobbleheads you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

