/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.common.GiftWasPromisedCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.effects.common.continuous.LifeTotalCantChangeControllerEffect;
import mage.abilities.keyword.ProtectionFromEverythingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PerchProtectionEffect
extends OneShotEffect {
    PerchProtectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "if the gift was promised, all permanents you control phase out, and until your next turn, your life total can't change and you gain protection from everything";
    }

    private PerchProtectionEffect(PerchProtectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerchProtectionEffect copy() {
        return new PerchProtectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (GiftWasPromisedCondition.FALSE.apply(game, source)) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game)) {
            permanent.phaseOut(game);
        }
        game.addEffect((ContinuousEffect)new LifeTotalCantChangeControllerEffect(Duration.UntilYourNextTurn), source);
        game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)new ProtectionFromEverythingAbility(), Duration.UntilYourNextTurn), source);
        return true;
    }
}

