/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class PeriBrownHistoricSpellWatcher
extends Watcher {
    private final Map<UUID, Integer> historicSpells = new HashMap<UUID, Integer>();

    public PeriBrownHistoricSpellWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())) != null && spell.isHistoric(game)) {
            this.historicSpells.put(event.getPlayerId(), this.historicSpellsCastThisTurn(event.getPlayerId()) + 1);
        }
    }

    public int historicSpellsCastThisTurn(UUID playerId) {
        return this.historicSpells.getOrDefault(playerId, 0);
    }

    public void reset() {
        super.reset();
        this.historicSpells.clear();
    }
}

