/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class PerilousPredicamentSacrificeOpponentsEffect
extends OneShotEffect {
    PerilousPredicamentSacrificeOpponentsEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each opponent sacrifices an artifact creature and a nonartifact creature";
    }

    private PerilousPredicamentSacrificeOpponentsEffect(PerilousPredicamentSacrificeOpponentsEffect effect) {
        super((OneShotEffect)effect);
    }

    public PerilousPredicamentSacrificeOpponentsEffect copy() {
        return new PerilousPredicamentSacrificeOpponentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList perms = new ArrayList();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            TargetSacrifice target;
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterArtifactCreaturePermanent filterArtifact = new FilterArtifactCreaturePermanent("an artifact creature");
            FilterCreaturePermanent filterNonArtifact = new FilterCreaturePermanent("a nonartifact creature");
            filterNonArtifact.add(Predicates.not((Predicate)CardType.ARTIFACT.getPredicate()));
            if (game.getBattlefield().countAll((FilterPermanent)filterArtifact, player.getId(), game) > 0 && (target = new TargetSacrifice((FilterPermanent)filterArtifact)).canChoose(player.getId(), source, game)) {
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                perms.addAll(target.getTargets());
            }
            if (game.getBattlefield().countAll((FilterPermanent)filterNonArtifact, player.getId(), game) <= 0 || !(target = new TargetSacrifice((FilterPermanent)filterNonArtifact)).canChoose(player.getId(), source, game)) continue;
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

