/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PestilenceDemonEffect
extends OneShotEffect {
    PestilenceDemonEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to each creature and each player";
    }

    private PestilenceDemonEffect(PestilenceDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            if (creature == null) continue;
            creature.damage(1, source.getSourceId(), source, game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.damage(1, source.getSourceId(), source, game);
        }
        return true;
    }

    public PestilenceDemonEffect copy() {
        return new PestilenceDemonEffect(this);
    }
}

