/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.ControllerGainedLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ExileSpellEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.GainLifeAllEffect;
import mage.abilities.effects.common.MillCardsEachPlayerEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.cards.CardSetInfo;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.permanent.token.Pest11GainLifeToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.common.TargetCardInASingleGraveyard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.watchers.Watcher;
import mage.watchers.common.PlayerGainedLifeWatcher;

public final class PestilentCauldron
extends ModalDoubleFacedCard {
    private static final FilterCard filter = new FilterCard("creature, land, and/or planeswalker cards from your graveyard");

    public PestilentCauldron(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, new SubType[0], "{2}{B}", "Restorative Burst", new CardType[]{CardType.SORCERY}, new SubType[0], "{3}{G}{G}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new CreateTokenEffect((Token)new Pest11GainLifeToken()), (Cost)new TapSourceCost());
        ability.addCost((Cost)new DiscardCardCost());
        this.getLeftHalfCard().addAbility((Ability)ability);
        ability = new SimpleActivatedAbility((Effect)new MillCardsEachPlayerEffect((DynamicValue)ControllerGainedLifeCount.instance, TargetController.OPPONENT).setText("each opponent mills cards equal to the amount of life you gained this turn"), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        ability.addWatcher((Watcher)new PlayerGainedLifeWatcher());
        this.getLeftHalfCard().addAbility(ability.addHint(ControllerGainedLifeCount.getHint()));
        ability = new SimpleActivatedAbility((Effect)new ExileTargetEffect(), (Cost)new GenericManaCost(4));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetCardInASingleGraveyard(4, 4, StaticFilters.FILTER_CARD_CARDS));
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(1));
        this.getLeftHalfCard().addAbility((Ability)ability);
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new ReturnFromGraveyardToHandTargetEffect());
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new GainLifeAllEffect(4));
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new ExileSpellEffect());
        this.getRightHalfCard().getSpellAbility().addTarget((Target)new TargetCardInYourGraveyard(0, 2, filter));
    }

    private PestilentCauldron(PestilentCauldron card) {
        super((ModalDoubleFacedCard)card);
    }

    public PestilentCauldron copy() {
        return new PestilentCauldron(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate(), CardType.PLANESWALKER.getPredicate()}));
    }
}

