/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PetalsOfInsightEffect
extends OneShotEffect {
    PetalsOfInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top three cards of your library. You may put those cards on the bottom of your library in any order. If you do, return {this} to its owner's hand. Otherwise, draw three cards";
    }

    private PetalsOfInsightEffect(PetalsOfInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public PetalsOfInsightEffect copy() {
        return new PetalsOfInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
        controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
        if (controller.chooseUse(this.outcome, "Put the cards on the bottom of your library in any order?", source, game)) {
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
            Card spellCard = game.getStack().getSpell(source.getSourceId()).getCard();
            if (spellCard != null) {
                controller.moveCards(spellCard, Zone.HAND, source, game);
            }
        } else {
            controller.drawCards(3, source, game);
        }
        return true;
    }
}

