/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.p.PhantasmalMountDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PhantasmalMountEffect
extends OneShotEffect {
    PhantasmalMountEffect() {
        super(Outcome.Neutral);
        this.staticText = "Target creature you control with toughness 2 or less gets +1/+1 and gains flying until end of turn. When {this} leaves the battlefield this turn, sacrifice that creature. When the creature leaves the battlefield this turn, sacrifice {this}";
    }

    private PhantasmalMountEffect(PhantasmalMountEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            BoostTargetEffect effect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            game.addEffect((ContinuousEffect)effect, source);
            SacrificeTargetEffect sacrificeCreatureEffect = new SacrificeTargetEffect();
            SacrificeTargetEffect sacrificePhantasmalMountEffect = new SacrificeTargetEffect();
            GainAbilityTargetEffect gainAbility = new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn);
            gainAbility.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            game.addEffect((ContinuousEffect)gainAbility, source);
            sacrificeCreatureEffect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            sacrificePhantasmalMountEffect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
            PhantasmalMountDelayedTriggeredAbility dTA = new PhantasmalMountDelayedTriggeredAbility((Effect)sacrificeCreatureEffect, source.getSourceId());
            PhantasmalMountDelayedTriggeredAbility dTA2 = new PhantasmalMountDelayedTriggeredAbility((Effect)sacrificePhantasmalMountEffect, source.getFirstTarget());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)dTA, source);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)dTA2, source);
            return true;
        }
        return false;
    }

    public PhantasmalMountEffect copy() {
        return new PhantasmalMountEffect(this);
    }
}

