/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class PhantomWings
extends CardImpl {
    public PhantomWings(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{U}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA)));
        this.addAbility((Ability)new SimpleActivatedAbility((Effect)new PhantomWingsReturnEffect(), (Cost)new SacrificeSourceCost()));
    }

    private PhantomWings(PhantomWings card) {
        super((CardImpl)card);
    }

    public PhantomWings copy() {
        return new PhantomWings(this);
    }

    private static final class PhantomWingsReturnEffect
    extends OneShotEffect {
        private PhantomWingsReturnEffect() {
            super(Outcome.ReturnToHand);
            this.staticText = "Return enchanted creature to its owner's hand";
        }

        private PhantomWingsReturnEffect(PhantomWingsReturnEffect effect) {
            super((OneShotEffect)effect);
        }

        public PhantomWingsReturnEffect copy() {
            return new PhantomWingsReturnEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player player = game.getPlayer(source.getControllerId());
            Permanent permanent = source.getSourcePermanentOrLKI(game);
            if (player == null || permanent == null || permanent.getAttachedTo() == null) {
                return false;
            }
            Permanent enchantedCreature = game.getPermanent(permanent.getAttachedTo());
            return enchantedCreature != null && player.moveCards((Card)enchantedCreature, Zone.HAND, source, game);
        }
    }
}

