/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PheliaExuberantShepherdEffect
extends OneShotEffect {
    private final UUID zoneId;

    PheliaExuberantShepherdEffect(UUID zoneId) {
        super(Outcome.Benefit);
        this.staticText = "return that card to the battlefield under its owner's control. If it entered under your control, put a +1/+1 counter on {this}";
        this.zoneId = zoneId;
    }

    private PheliaExuberantShepherdEffect(PheliaExuberantShepherdEffect effect) {
        super((OneShotEffect)effect);
        this.zoneId = effect.zoneId;
    }

    public PheliaExuberantShepherdEffect copy() {
        return new PheliaExuberantShepherdEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(this.zoneId);
        if (exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        Set cards = exileZone.getCards(game);
        player.moveCards(cards, Zone.BATTLEFIELD, source, game, false, false, true, null);
        game.processAction();
        Permanent phelia = source.getSourcePermanentIfItStillExists(game);
        if (phelia == null) {
            return true;
        }
        boolean enteredUnderYourControl = false;
        for (Card card : cards) {
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent == null || !permanent.getControllerId().equals(source.getControllerId())) continue;
            enteredUnderYourControl = true;
            break;
        }
        if (!enteredUnderYourControl) {
            return true;
        }
        phelia.addCounters(CounterType.P1P1.createInstance(), source, game);
        return true;
    }
}

