/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PhthisisEffect
extends OneShotEffect {
    PhthisisEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. Its controller loses life equal to its power plus its toughness";
    }

    private PhthisisEffect(PhthisisEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhthisisEffect copy() {
        return new PhthisisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null && (controller = game.getPlayer(creature.getControllerId())) != null) {
            int lifeLoss = CardUtil.overflowInc((int)creature.getPower().getValue(), (int)creature.getToughness().getValue());
            creature.destroy(source, game, false);
            controller.loseLife(lifeLoss, game, source, false);
            return true;
        }
        return false;
    }
}

