/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.cards.p.ExileTopCardLibraryCost;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class PhyrexianDevourerEffect
extends OneShotEffect {
    PhyrexianDevourerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put X +1/+1 counters on {this}, where X is the exiled card's mana value";
    }

    private PhyrexianDevourerEffect(PhyrexianDevourerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PhyrexianDevourerEffect copy() {
        return new PhyrexianDevourerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount;
            Card card = null;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof ExileTopCardLibraryCost)) continue;
                card = ((ExileTopCardLibraryCost)cost).getCard();
            }
            if (card != null && (amount = card.getManaValue()) > 0) {
                return new AddCountersSourceEffect(CounterType.P1P1.createInstance(amount)).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

